#!/bin/bash
# Auteur: B-X Massot
# Chaque source:
#   - mesure en interne sa fonction de tri.
#   - envoie vers stderr le résultat du tri sur une seule ligne
#   - envoie vers stdout le temps en microsecondes

NBTESTS=20
comp="gcc -Wall -s -o "

# Ecrit header HTML
cat > ./page.html<< 'fic'
<!doctype html>
<html>
<head>
<title>Tri d'entiers</title>
<meta charset="utf-8">
</head>
<body>
<center>
<table border="1" style="border-collapse:collapse">
<caption>gd: grand tableau. pt: petit tableau</caption>
<tr align="center" bgcolor="#fad77f">
 <td>Source</td>
 <td>Temps</td>
 <td>Moyenne</td>
 <td>+rapide</td>
 <td>+lent</td>
 <td>Sortie</td>
</tr>
fic

# Pour chaque fichier c du dossier,
#   - compile,
#   - lance NBTESTS, append à src.tps.txt et src.out.txt
#   - appelle binaire moyenne qui sort |moy|min|max sur stdout
#   - append ligne table html

for SRC in *.c
do
 pos=`expr index "$SRC" .`     # position du point?
 RAC=`expr substr $SRC 1 $pos` # extrait racine

 TPS=test/$RAC"tps.txt"
 OUT=test/$RAC"out.txt"
 EXE=$RAC.x

 $comp $EXE $SRC
 if test -r $TPS; then rm $TPS; fi
 if test -r $OUT; then rm $OUT; fi

 # fait le test de validité
  ./$EXE 1>/dev/null 2>>$OUT

 # lance x tests
 for i in `seq 1 $NBTESTS`;
 do
  ./$EXE 1>>$TPS 2>/dev/null
 done
 #rm $EXE
 # appelle moyenne et coupe string en variables
 line=`bin/moyenne $TPS`
   moy=`echo $line | cut -f2 -d'|'`
   rapi=`echo $line | cut -f3 -d'|'`
   lent=`echo $line | cut -f4 -d'|'`
 # Ajoute entrée à la page HTML
  echo "<tr align=\"center\">" >>page.html
  echo " <td><a href=\"$SRC\" target=\"blank\">$SRC</a></td>">>page.html
  echo " <td><a href=\"$TPS\" target=\"blank\">temps</a></td>">>page.html
  echo " <td>$moy</td>"  >>page.html
  echo " <td>$rapi</td>" >>page.html
  echo " <td>$lent</td>" >>page.html
  echo " <td><a href=\"$OUT\" target=\"blank\">sortie</a></td>">>page.html
  echo "</tr>" >>page.html
done

# Ecrit footer HTML
echo "<tr>"             >>page.html
echo " <td colspan=\"6\"><font size=2><i><center>Les temps sont en microsecondes. Chaque source a été testée $NBTESTS fois.</center></i></font></td>">>page.html
echo "</tr>"            >>page.html
echo "</table></center>">>page.html
echo "</body></html>"   >>page.html
