//  quickSort
//
//  This public-domain C implementation by Darel R. Finley.
//  http://alienryderflex.com/quicksort/
//
//  * Returns true if sort was successful, or false if the nested
//    pivots went too deep, in which case your array will have
//    been re-ordered, but probably not sorted correctly.
//
//  * This function assumes it is called with valid parameters.
//
//  * Example calls:
//    quickSort(&myArray[0],5); // sorts elements 0, 1, 2, 3, and 4
//    quickSort(&myArray[3],5); // sorts elements 3, 4, 5, 6, and 7

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

char quickSort(int *arr, int elements) {

  #define MAX_LEVELS 1000

  int  piv, beg[MAX_LEVELS], end[MAX_LEVELS], i=0, L, R ;

  beg[0]=0; end[0]=elements;
  while (i>=0) {
    L=beg[i]; R=end[i]-1;
    if (L<R) {
      piv=arr[L]; if (i==MAX_LEVELS-1) return 0;
      while (L<R) {
        while (arr[R]>=piv && L<R) R--; if (L<R) arr[L++]=arr[R];
        while (arr[L]<=piv && L<R) L++; if (L<R) arr[R--]=arr[L]; }
      arr[L]=piv; beg[i+1]=L+1; end[i+1]=end[i]; end[i++]=L; }
    else {
      i--; }}
  return 1; }

int main ()
{
  struct timeval depart, fin;
  struct timezone tz;
  int n;
  int i[19]={102,89,69,9,56,59,85,44,66,12,36,458,965,254,588,632,45,778,666};

  gettimeofday(&depart, &tz);
  n = quickSort(i, 19);
  gettimeofday(&fin, &tz);
  printf("%ld", (fin.tv_sec-depart.tv_sec) * 1000000L + (fin.tv_usec-depart.tv_usec));

  for (n=0; n<19; n++)
    fprintf (stderr, "%d ", i[n]);
  printf ("\n");
  return 0;
}
