/*
  Sort integers without qsort,
  using algorithm "counting sort"
  source: http://en.wikipedia.org/wiki/Counting_sort
*/
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <sys/time.h>

/* end is the last index + 1 */
void csort(int array[], const int end, const int max, const int min)
{
  int i;
  const int range = max-min+1;
  int count[range+1], scratch[end];

  for(i=0; i<range+1; i++)
    count[i] = 0;

  /* Set the value of count[i] to the number of
   * elements in array with value i+min-1. */
  for(i=0; i<end; i++) {
    int c = array[i]+1-min;
    count[c]++;
  }

  /* Update count[i] to be the number of
   * elements with value less than i+min. */
  for(i=1; i<range; i++)
    count[i] += count[i-1];

  /* Copy the elements of array into scratch in
   * stable sorted order. */
  for(i=(end-1); i>=0; i--) {
    int c = array[i]-min;
    int s = count[c];
    scratch[s] = array[i];
    /* Increment count so that the next element
     * with the same value as the current element
     * is placed into its own position in scratch. */
    count[c]++;
  }

  for(i=0; i<end; i++)
    array[i] = scratch[i];
}

int main(int argc, char* argv[])
{
  struct timeval depart, fin;
  struct timezone tz;
  int n;
  int i[19]={ 102,89,69,9,56,59,85,44,66,12,36,458,965,254,588,632,45,778,666};

  gettimeofday(&depart, &tz);
  csort(i, 19, 965, 9);
  gettimeofday(&fin, &tz);
  printf("%ld", (fin.tv_sec-depart.tv_sec) * 1000000L + (fin.tv_usec-depart.tv_usec));

  for (n=0; n<19; n++)
    fprintf (stderr, "%d ", i[n]);
  printf ("\n");
  return 0;
}
